
export enum AgentType {
  RON = 'RON',
  WYATT = 'WYATT',
  DANA = 'DANA',
  CHARLIE = 'CHARLIE',
  DASH = 'DASH',
}

export interface AgentProfile {
  id: AgentType;
  name: string;
  role: string;
  description: string;
  avatarColor: string;
  icon: string;
  avatarUrl?: string; // Optional generated image URL
}

/**
 * Aligned with @google/genai SDK response structure where fields are optional.
 */
export interface GroundingChunk {
  web?: {
    uri?: string;
    title?: string;
  };
  maps?: {
    uri?: string;
    title?: string;
    placeAnswerSources?: {
      reviewSnippets?: {
        snippet?: string;
        sourceUri?: string;
      }[];
    }[];
  };
}

export interface FeedbackItem {
  id: string;
  type: 'positive' | 'negative';
  comment: string;
  upvotes: number;
  downvotes: number;
  timestamp: number;
  callsign?: string;
  userId?: string;
}

export interface AgentResponse {
  text: string;
  groundingChunks?: GroundingChunk[];
  timestamp: number;
}

export interface AgentState {
  isLoading: boolean;
  error: string | null;
  data: AgentResponse | null;
}

export interface ClimateDataPoint {
  month: string;
  high: number;
  low: number;
}
