
import { AgentProfile, AgentType } from './types';

export const AGENTS: Record<AgentType, AgentProfile> = {
  [AgentType.RON]: {
    id: AgentType.RON,
    name: "Runway Ron",
    role: "CFI | Ops & Procedures",
    description: "Pattern entries & technical specs.",
    avatarColor: "bg-mcm-teal",
    icon: "TOWER"
  },
  [AgentType.WYATT]: {
    id: AgentType.WYATT,
    name: "Weather Wyatt",
    role: "Met & Seasonal",
    description: "Seasonal VFR & climate trends.",
    avatarColor: "bg-mcm-mustard",
    icon: "CLOUD"
  },
  [AgentType.DANA]: {
    id: AgentType.DANA,
    name: "Diner Dana",
    role: "Lifestyle & Stay",
    description: "Pilot-tested eats, stays, and transportation.",
    avatarColor: "bg-mcm-rust",
    icon: "FOOD"
  },
  [AgentType.CHARLIE]: {
    id: AgentType.CHARLIE,
    name: "Chief Charlie",
    role: "Safety & Checklists",
    description: "Safety briefs & PAVE risks.",
    avatarColor: "bg-mcm-sand",
    icon: "CHECKLIST"
  },
  [AgentType.DASH]: {
    id: AgentType.DASH,
    name: "Dispatch Dash",
    role: "Dispatch & Regulations",
    description: "Advanced planning & FAR/AIM intel.",
    avatarColor: "bg-mcm-indigo",
    icon: "GLOBE"
  }
};

export const SAMPLE_AIRPORTS = [
  { code: "KSEZ", name: "Sedona, AZ" },
  { code: "L35", name: "Big Bear, CA" },
  { code: "KATL", name: "Atlanta, GA" },
  { code: "KJFK", name: "New York, NY" },
];
