
import React from 'react';

interface LogoProps {
  className?: string;
  width?: string;
}

export const Logo: React.FC<LogoProps> = ({ className = "", width = "w-full" }) => {
  return (
    <div className={`${width} ${className} relative inline-block select-none`}>
      <svg
        viewBox="0 0 455.76 120.93"
        className="w-full h-auto drop-shadow-xl"
        preserveAspectRatio="xMidYMid meet"
        xmlns="http://www.w3.org/2000/svg"
      >
        <polygon fill="#EF4136" points="444.23 93.73 30.16 120.93 0 0 455.76 23.11 444.23 93.73"/>
        <g fill="#FFFFFF">
          <g>
            <path d="M48.33,64.65l-7.47,12.8h-10.7l26.28-42.47h13.14l8.54,42.47h-10.7l-2.23-12.8h-16.87ZM61.33,42.49l-9.05,15.45h11.77l-2.73-15.45Z"/>
            <path d="M96.49,55.98h20.35l-1.19,5.85h-20.41l-2,9.77h22.54l-1.25,5.85h-31.12l7.64-37.04h30.49l-1.19,5.8h-21.85l-2,9.77Z"/>
            <path d="M149.96,59.68c3.69,1.07,4.88,4.03,4.88,11.17,0,2.84.38,5.05,1.25,6.6h-9.33c-.38-1.77-.5-3.7-.56-9.07,0-3.44-1.25-5.58-4.38-5.8-1.13-.05-2.19-.05-3.32-.05h-5.07l-3.07,14.92h-8.64l7.64-37.04h15.78c2.5,0,4.13.05,6.26.27,5.38.54,9.52,2.95,9.52,8.05,0,5.96-4.45,9.55-10.96,10.95ZM151.46,50.51c0-2.74-1.94-3.87-4.76-4.13-1-.11-2.07-.16-3.57-.16h-6.32l-2.25,10.79h6.01c1.5,0,2.5,0,3.57-.05,3.88-.32,7.33-2.15,7.33-6.44Z"/>
            <path d="M207.81,55.71c0,12.67-9.45,22.49-24.79,22.49-12.4,0-19.22-7.09-19.22-16.05,0-12.67,9.45-22.49,24.79-22.49,12.4,0,19.22,7.09,19.22,16.05ZM198.6,55.87c0-6.33-3.88-10.68-10.71-10.68-10.14,0-14.9,9.23-14.9,16.8,0,6.33,3.82,10.68,10.71,10.68,10.14,0,14.9-9.23,14.9-16.8Z"/>
            <path d="M253.39,56.25c0,10.25-7.45,19.81-22.6,21.04-2.25.16-3.44.16-5.57.16h-14.21l7.64-37.04h13.65c2.25,0,3.63,0,5.76.21,8.58.75,15.34,5.64,15.34,15.62ZM244.12,56.46c0-6.55-3.63-9.55-8.83-10.09-1.38-.11-2.57-.16-4.32-.16h-4.88l-5.26,25.39h5.07c1.75,0,3,0,4.45-.11,9.58-1.02,13.77-7.68,13.77-15.03Z"/>
            <path d="M284.82,59.68c3.69,1.07,4.88,4.03,4.88,11.17,0,2.84.38,5.05,1.25,6.6h-9.33c-.38-1.77-.5-3.7-.56-9.07,0-3.44-1.25-5.58-4.38-5.8-1.13-.05-2.19-.05-3.32-.05h-5.07l-3.07,14.92h-8.64l7.64-37.04h15.78c2.5,0,4.13.05,6.26.27,5.38.54,9.52,2.95,9.52,8.05,0,5.96-4.44,9.55-10.96,10.95ZM286.32,50.51c0-2.74-1.94-3.87-4.76-4.13-1-.11-2.07-.16-3.57-.16h-6.32l-2.25,10.79h6.01c1.5,0,2.5,0,3.57-.05,3.88-.32,7.33-2.15,7.33-6.44Z"/>
            <path d="M342.67,55.71c0,12.67-9.45,22.49-24.79,22.49-12.4,0-19.22-7.09-19.22-16.05,0-12.67,9.45-22.49,24.79-22.49,12.4,0,19.22,7.09,19.22,16.05ZM333.47,55.87c0-6.33-3.88-10.68-10.71-10.68-10.14,0-14.9,9.23-14.9,16.8,0,6.33,3.82,10.68,10.71,10.68,10.14,0,14.9-9.23,14.9-16.8Z"/>
            <path d="M392.44,77.45h-8.64l6.26-29.79-15.78,29.79h-10.27l-3.44-29.9-6.07,29.9h-8.64l7.64-37.04h14.09l3.25,29.26,14.9-29.26h14.34l-7.64,37.04Z"/>
            <path d="M414.86,55.98h20.35l-1.19,5.85h-20.41l-2,9.77h22.54l-1.25,5.85h-31.12l7.64-37.04h30.49l-1.19,5.8h-21.85l-2,9.77Z"/>
          </g>
          <path d="M419.28,81.44v1.09h-2.46v5.51h-1.53v-5.51h-2.47v-1.09h6.46ZM427.61,88.04l-.28-3.89c-.03-.51-.03-1.14-.06-1.85h-.08c-.2.58-.42,1.36-.65,1.97l-1.39,3.67h-1.59l-1.39-3.77c-.14-.51-.37-1.29-.54-1.87h-.08c0,.61-.03,1.24-.06,1.85l-.28,3.89h-1.47l.57-6.61h2.29l1.33,3.23c.17.51.31,1,.51,1.68h.03c.2-.61.37-1.17.54-1.65l1.33-3.25h2.21l.59,6.61h-1.53Z"/>
        </g>
      </svg>
    </div>
  );
};
